VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDatabase"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Sub Load_Database()
On Error Resume Next
Dim strTmp As String
Dim Splt() As String
Dim FUser As Boolean, FGroup As Boolean, FMaster As Boolean
Open clsBotVars.NDB_Path For Append As #1
Close #1
Open clsBotVars.NDB_Path For Input As #1

Do Until EOF(1)
Input #1, strTmp
    Splt() = Split(strTmp, "")
    
    If strTmp = "}" Then
        FGroup = False
        FUser = False
        FMaster = False
    End If
    
    If UCase$(strTmp) = "GROUP {" Then FGroup = True: FUser = False: FMaster = False
    If UCase$(strTmp) = "USER {" Then FUser = True: FGroup = False: FMaster = False
    If UCase$(strTmp) = "MASTER {" Then FMaster = True: FGroup = True: FUser = False
    
    'Load Group(s):
    If FGroup = True Then
        If InStr(strTmp, "") And UCase(strTmp) <> "GROUP {" Then
            'THEGROUPACCESSTIME_ADDEDDATE_ADDEDADDED_USERCHANNELBAN_MSG
            If Left$(LCase$(Splt(0)), 4) = "grp_" Then
                G_DB(UBound(G_DB)).Group_Name = UCase$(Splt(0))
                G_DB(UBound(G_DB)).Access = ConvertAccess(Splt(1))
                If Splt(2) = 0 Then Splt(2) = Get_FILETIME
                G_DB(UBound(G_DB)).FILETIME = Splt(2)
                G_DB(UBound(G_DB)).Added_By = Splt(3)
                G_DB(UBound(G_DB)).Channel = Splt(4)
                G_DB(UBound(G_DB)).Ban_Message = Splt(5)
                'AddC frmMain.RTB1, QBColor(6), G_DB(UBound(G_DB)).Group_Name
                If Index_DB(Splt(0), Group) = -1 And G_DB(UBound(G_DB)).Group_Name <> vbNullString Then
                    'Debug.Print G_DB(UBound(G_DB)).Group_Name
                    'Debug.Print G_DB(UBound(G_DB)).Access
                    ReDim Preserve G_DB(UBound(G_DB) + 1)
                End If
            End If
        End If
    End If
    
    'Load User(s):
    If FUser = True Then
        If InStr(strTmp, "") And UCase(strTmp) <> "USER {" Then
            'USERNAMEACCESSTIME_DATEADDED_USERCHANNELBAN_MSG
            U_DB(UBound(U_DB)).Username = Splt(0)
            If Index_DB(Splt(1), Group) > -1 Then
                U_DB(UBound(U_DB)).Access = Splt(1)
            Else
                U_DB(UBound(U_DB)).Access = ConvertAccess(Splt(1))
            End If
            If Splt(2) = 0 Then Splt(2) = Get_FILETIME
            U_DB(UBound(U_DB)).FILETIME = Splt(2)
            U_DB(UBound(U_DB)).Added_By = Splt(3)
            U_DB(UBound(U_DB)).Channel = Splt(4)
            U_DB(UBound(U_DB)).Ban_Message = Splt(5)
            'AddC frmMain.RTB1, QBColor(6), U_DB(UBound(U_DB)).Username
            If Index_DB(Splt(0), User) = -1 And U_DB(UBound(U_DB)).Username <> vbNullString Then
                ReDim Preserve U_DB(UBound(U_DB) + 1)
            End If
        End If
    End If
    
    'Load Master(s):
    If FMaster = True Then
        If strTmp <> vbNullString And UCase(strTmp) <> "MASTER {" Then
            strTmp = Replace(strTmp, Space(1), vbNullString)
            Masters(UBound(Masters)) = strTmp
            'AddC frmMain.RTB1, QBColor(6), Masters(UBound(Masters))
            If Index_DB(strTmp, Master) = -1 Then
                ReDim Preserve Masters(UBound(Masters) + 1)
            End If
        End If
    End If
Loop
Close #1

If UBound(Masters) = 0 Then
    Masters(UBound(Masters)) = InputBox("There are currently no masters in the database, please create one now.", "Database Error")
    If Masters(UBound(Masters)) = vbNullString Then End
    ReDim Preserve Masters(UBound(Masters) + 1)
End If

AddC frmMain.RTB2, RGB(6, 110, 158), "Group(s): ", QBColor(7), UBound(G_DB), RGB(6, 110, 158), ", ", RGB(6, 110, 158), "User(s): ", QBColor(7), UBound(U_DB), RGB(6, 110, 158), ", and ", RGB(6, 110, 158), "Master(s): ", QBColor(7), UBound(Masters)
End Sub

Public Sub SaveDatabase()
Dim i As Integer
Open clsBotVars.NDB_Path For Append As #1
Close #1
Open clsBotVars.NDB_Path For Output As #1

Print #1, "Master {"
'MASTER
For i = 0 To UBound(Masters) - 1
    Print #1, Masters(i)
Next i
    
Print #1, "}" & vbNewLine
Print #1, "Group {"
'THEGROUPACCESSTIME_ADDEDDATE_ADDEDADDED_USERCHANNELBAN_MSG
For i = 0 To UBound(G_DB) - 1
    Print #1, UCase$(G_DB(i).Group_Name) & "" & ReconvertAccess(G_DB(i).Access) & "" & G_DB(i).FILETIME & "" & G_DB(i).Added_By & "" & G_DB(i).Channel & "" & G_DB(i).Ban_Message
Next i
Print #1, "}" & vbNewLine

Print #1, "User {"
''USERNAMEACCESSTIME_ADDEDDATE_ADDEDADDED_USERCHANNELBAN_MSG
For i = 0 To UBound(U_DB) - 1
    If Index_DB(U_DB(i).Access, Group) > -1 Then
        Print #1, U_DB(i).Username & "" & U_DB(i).Access & "" & U_DB(i).FILETIME & "" & U_DB(i).Added_By & "" & U_DB(i).Channel & "" & U_DB(i).Ban_Message
    ElseIf IsNumeric(U_DB(i).Access) = True Then
        Print #1, U_DB(i).Username & "" & ReconvertAccess(U_DB(i).Access) & "" & U_DB(i).FILETIME & "" & U_DB(i).Added_By & "" & U_DB(i).Channel & "" & U_DB(i).Ban_Message
    Else
        MsgBox "Error saving: " & U_DB(i).Username & " to the database. Access => " & U_DB(i).Access, vbCritical
    End If
Next i
Print #1, "}" & vbNewLine

Close #1
End Sub

Public Function Set_DB(ByVal strName As String, ByVal strAdded_By As String, ByVal Access As Long, ByVal eType As DB_Types, Optional ByVal strBan_Msg As String = vbNullString) As Boolean
Dim Index As Integer
Index = Index_DB(strName, eType)
If ModVars.strCurrent_Channel = vbNullString Then
    ModVars.strCurrent_Channel = "<system>"
End If

'MUST CHECK FOR 'GRP_' PREFIX! (OFFICIAL OVERRIDE PROTECTION)
If eType = Group And Left$(LCase$(strName), 4) <> "grp_" Then
    Set_DB = False
    Exit Function
End If

If Index = -1 Then
    Select Case eType
        Case Master
                Masters(UBound(Masters)) = strName
                ReDim Preserve Masters(UBound(Masters) + 1)
                Set_DB = True
        Case Group
                G_DB(UBound(G_DB)).Access = Access
                G_DB(UBound(G_DB)).Added_By = strAdded_By
                G_DB(UBound(G_DB)).Ban_Message = strBan_Msg
                G_DB(UBound(G_DB)).Channel = ModVars.strCurrent_Channel
                G_DB(UBound(G_DB)).FILETIME = Get_FILETIME
                G_DB(UBound(G_DB)).Group_Name = UCase$(strName)
                ReDim Preserve G_DB(UBound(G_DB) + 1)
                Set_DB = True
        Case User
                U_DB(UBound(U_DB)).Access = Access
                U_DB(UBound(U_DB)).Added_By = strAdded_By
                U_DB(UBound(U_DB)).Ban_Message = strBan_Msg
                U_DB(UBound(U_DB)).Channel = ModVars.strCurrent_Channel
                U_DB(UBound(U_DB)).FILETIME = Get_FILETIME
                U_DB(UBound(U_DB)).Username = strName
                ReDim Preserve U_DB(UBound(U_DB) + 1)
                Set_DB = True
    End Select
ElseIf Index > -1 Then
    Select Case eType
        Case Master
            Masters(Index) = strName
            Set_DB = True
        Case Group
            G_DB(Index).Access = Access
            G_DB(Index).Added_By = strAdded_By
            G_DB(Index).Ban_Message = strBan_Msg
            G_DB(Index).Channel = ModVars.strCurrent_Channel
            G_DB(Index).FILETIME = Get_FILETIME
            G_DB(Index).Group_Name = UCase$(strName)
            If G_DB(Index).Access = 0 Then
                Call Destroy_Grouped_Users(G_DB(Index).Group_Name)
                Delete_DB Index, Group
            End If
            Set_DB = True
        Case User
            U_DB(Index).Access = Access
            U_DB(Index).Added_By = strAdded_By
            U_DB(Index).Ban_Message = strBan_Msg
            U_DB(Index).Channel = ModVars.strCurrent_Channel
            U_DB(Index).FILETIME = Get_FILETIME
            U_DB(Index).Username = strName
            If U_DB(Index).Access = 0 Then Delete_DB Index, User
            Set_DB = True
    End Select
End If
End Function

Public Function Group_User_Add(ByVal Name As String, ByVal strAdded_By As String, ByVal strGroup_Name As String, Optional ByVal strBan_Msg As String = vbNullString) As Boolean
Dim Index As Integer
Index = Index_DB(Name, User)
If Index_DB(strGroup_Name, Group) <> -1 Then
    If Index = -1 Then
        U_DB(UBound(U_DB)).Access = strGroup_Name
        U_DB(UBound(U_DB)).Added_By = strAdded_By
        U_DB(UBound(U_DB)).Ban_Message = strBan_Msg
        U_DB(UBound(U_DB)).Channel = ModVars.strCurrent_Channel
        U_DB(UBound(U_DB)).FILETIME = Get_FILETIME
        U_DB(UBound(U_DB)).Username = Name
        ReDim Preserve U_DB(UBound(U_DB) + 1)
    Else
        U_DB(Index).Access = strGroup_Name
        U_DB(Index).Added_By = strAdded_By
        U_DB(Index).Ban_Message = strBan_Msg
        U_DB(Index).Channel = ModVars.strCurrent_Channel
        U_DB(Index).FILETIME = Get_FILETIME
        U_DB(Index).Username = Name
    End If
    Group_User_Add = True
End If
End Function

Public Function Delete_DB(ByVal Index As Integer, ByVal e_Type As DB_Types) As Boolean
    Dim i As Integer
    If Index >= 0 Then
        Select Case e_Type
            Case User
                If Index - 1 > UBound(U_DB) Then Exit Function
                For i = Index To UBound(U_DB) - 1
                      U_DB(i) = U_DB(i + 1)
                Next i
                ReDim Preserve U_DB(UBound(U_DB) - 1)
                Delete_DB = True
            Case Group
                If Index - 1 > UBound(G_DB) Then Exit Function
                Call Destroy_Grouped_Users(G_DB(i).Group_Name)
                For i = Index To UBound(G_DB) - 1
                      G_DB(i) = G_DB(i + 1)
                Next i
                ReDim Preserve G_DB(UBound(G_DB) - 1)
                Delete_DB = True
            Case Master
                If Index - 1 > UBound(Masters) Then Exit Function
                For i = Index To UBound(Masters) - 1
                      Masters(i) = Masters(i + 1)
                Next i
                ReDim Preserve Masters(UBound(Masters) - 1)
                Delete_DB = True
        End Select
    End If
End Function

Private Sub Destroy_Grouped_Users(ByVal Group As String)
On Error Resume Next
    Dim i As Integer
    For i = UBound(U_DB) To 0 Step -1
        If StrComp(U_DB(i).Access, Group, vbTextCompare) = 0 Then
            Debug.Print U_DB(i).Username
            Call Delete_DB(i, User)
        End If
    Next i
End Sub
